// CheetahBullet.js
//

function buildUI(tag){
    tag.addParameterSeparator("CheetahBullet SoftBody");
    
    tag.addParameterFloat("mass", 1.0, 0, 10000, true, true);
    tag.addParameterFloat("margin", 0.25, 0, 1000, true, true);
    
    tag.addParameterSeparator("Material");
    tag.addParameterFloat("linear stiffness", 1, 0, 1, true, true); //kLST
    tag.addParameterFloat("area stiffness", 1, 0, 1, true, true); //kAST
    tag.addParameterFloat("volume stiffness", 1, 0, 1, true, true); //kVST
    
    tag.addParameterSeparator("SoftBody");
    tag.addParameterFloat("velocities correction", 1, 0, 10000, true, true); // kVCF
    tag.addParameterFloat("damping", 0, 0, 1, true, true); // kDP
    tag.addParameterFloat("pressure", 0, -10000, 10000, true, true); //kPR
    
    tag.addParameterFloat("volume conversation", 0, 0, 10000, true, true); //kVC
    tag.addParameterFloat("dynamic friction", 0.2, 0, 1, true, true); //kDF
    tag.addParameterFloat("pose matching", 0, 0, 1, true, true); //kMT
    
    tag.addParameterInt("bending constraints", 2, 0, 256, true, true);
    
    tag.addParameterFloat("rigid contacts hardness", 1.0, 0, 1, true, true); //kCHR
    tag.addParameterFloat("kinetic contacts hardness", 0.1, 0, 1, true, true); //kKHR
    tag.addParameterFloat("soft contacts hardness", 1.0, 0, 1, true, true); //kSHR
    tag.addParameterFloat("anchors contacts hardness", 0.7, 0, 1, true, true); //kAHR
    
    tag.addParameterFloat("max volume ratio", 1.0, 0, 1, true, true); //maxvolume
    tag.addParameterFloat("time scale", 1, 0, 10000, true, true); //timescale
    
    tag.addParameterSeparator("Collision");
    
    tag.addParameterBool("use cluster", 0, 0, 1, true, true);
    tag.addParameterBool("self collision", 0, 0, 1, true, true);
    
    tag.addParameterSeparator("Cluster");
    
    tag.addParameterInt("cluster count", 4, 0, 8192, true, true);
    
    tag.addParameterFloat("rigid contacts cl hardness", 0.1, 0, 1, true, true); //kSRHR_CL
    tag.addParameterFloat("kinetic contacts cl hardness", 1.0, 0, 1, true, true); //kSKHR_CL
    tag.addParameterFloat("soft contacts cl hardness", 0.5, 0, 1, true, true); //kSSHR_CL
    
    tag.addParameterFloat("rigid contacts cl sp hardness", 0.5, 0, 1, true, true); //kSR_SPLT_CL
    tag.addParameterFloat("kinetic contacts cl sp hardness", 0.5, 0, 1, true, true); //kSK_SPLT_CL
    tag.addParameterFloat("soft contacts cl sp hardness", 0.5, 0, 1, true, true); //kSS_SPLT_CL
    
    tag.addParameterSeparator("Pose");
    tag.addParameterSelector("set pose", ["none", "frame", "volume", "frame+volume"], true, true); // set pose
    
    tag.addParameterSeparator("Aero Dynamics");
    tag.addParameterSelector("aero model", ["V_Point", "V_TwoSided", "V_OneSided", "F_TwoSided", "F_OneSided"], true, true); // aeromodel
    tag.addParameterFloat("drag", 0, 0, 10000, true, true); //kDG - related aerodynamics
    tag.addParameterFloat("lift", 0, 0, 10000, true, true); //kLF - related aerodynamics
    
    tag.addParameterSeparator("Solver Iterations");
    tag.addParameterInt("velocities iter.", 0, 0, 256, true, true); //viterations
    tag.addParameterInt("position iter.", 1, 0, 256, true, true); //piterations
    tag.addParameterInt("drift iter.", 0, 0, 256, true, true); //diterations
    tag.addParameterInt("cluster iter.", 4, 0, 256, true, true); //citerations
    
}

